	.include	'eq.s'
	.include	'externs.s'

	.text
titleloop::

	bsr		t_anm

	move.l	#titlobjs,FIRSTOBJ_ADR	;address of first object header
	move.l	#TITLE_OBJS,TOTOBJS_ADR	;total objects in list
	bsr		do_build				;build packed object list

	bsr		input
	bsr		titlinput
	rts

gotitle::
	clr.w	t_count				;animation counter
	move.w	#SCRN_RIGHT,t_ship+O_XPOS
	move.w	#SCRN_TOP-140,t_ship+O_YPOS
	move.l	#$00202020,t_ship+O_SCALE
	or.b		#DELETE_OBJ,t_cr+O_TYPE	;turn off CR logo
	and.b	#$7F,t_ship+O_TYPE		;turn on ship
	move.l	#0,t_cg+O_SCALE
	move.w	#198,t_cg+O_XPOS
	move.w	#SCRN_TOP+144,t_cg+O_YPOS

	move.l	#tship00,t_ship+O_DATA
	move.w	#184,t_ship+O_HEIGHT
	move.w	#80,t_ship+O_DWIDTH
	move.w	#80,t_ship+O_IWIDTH

	cmp.b	#TITLE_MODE,gamemode
	beq.b	.90					;don't need to reload graphics if already on title screen
;get the object data for the title screen
	jsr		clearscr
	bsr		ld_decmp				;load decompression GPU code
	move.l	#q65,a3				;starting address of default dq_table
	bsr		load_dq

	move.l	#titlebkg,a0			;table with decompression info
	move.w	#1,d0				;number of objects to decompress
	bsr		dodecomp				;load just the background for now

	bsr		ld_bldsc				;load object list builder GPU code for scaled objects

	move.l	#titlobjs,FIRSTOBJ_ADR	;address of first object header
	move.l	#1,TOTOBJS_ADR			;only the background
	bsr		do_build				;build packed object list
	bsr		wait_int

	bsr		ld_decmp				;load decompression GPU code
	move.l	#q65,a3				;starting address of default dq_table
	bsr		load_dq

	bsr		ld_tship

	bsr		ld_bldsc				;load object list builder GPU code for scaled objects

.90:
	move.b	#TITLE_MODE,gamemode
	rts	

t_anm::
	cmp.l	#$00000000,t_ship+O_SCALE
	beq		.60
	cmp.w	#116,t_count
	bne.b	.10
	move.w	#200,t_ship+O_HEIGHT
	move.w	#64,t_ship+O_DWIDTH
	move.w	#64,t_ship+O_IWIDTH
	move.l	#tship01,t_ship+O_DATA
	move.w	#SCRN_TOP+500,t_ship+O_YPOS
.10:
	add.w	#1,t_count
	cmp.w	#116,t_count
	bge		.50
	sub.w	#7,t_ship+O_XPOS
	add.w	#4,t_ship+O_YPOS

	bra		.90

.50:
	tst.w	t_ship+O_XPOS
	bpl.b	.52
	cmp.w	#-256,t_ship+O_XPOS
	blt.b	.55
.52:	move.w	t_count,d0
	and.w	#1,d0
	beq.b	.55
	sub.l	#$00010101,t_ship+O_SCALE
	add.w	#4,t_ship+O_YPOS
	add.w	#4,t_ship+O_XPOS
.55:	sub.w	#4,t_ship+O_YPOS
.58:	add.w	#5,t_ship+O_XPOS
	bra.b	.70
.60:	or.b		#DELETE_OBJ,t_ship+O_TYPE
	bra.b	.80
.70:
	cmp.l	#$00202020,t_cg+O_SCALE
	beq.b	.90
	add.l	#$00010101,t_cg+O_SCALE
	sub.w	#2,t_cg+O_XPOS
	sub.w	#4,t_cg+O_YPOS
	bra.b	.90

.80:	and.b	#$7F,t_cr+O_TYPE			;turn on CR logo

.90:	rts

ld_tship::
	move.l	#titledcm,a0			;table with decompression info
	move.w	#4,d0				;number of objects to decompress
	bsr		dodecomp

	move.l	#cglogo,ADJBLACK_START			;destination address
	move.l	#crlogo+(96*72*2),ADJBLACK_END	;total size
	jsr		adjblak
	move.l	#tship00,ADJBLACK_START			;destination address
	move.l	#tship01+(256*200*2),ADJBLACK_END	;total size
	jsr		adjblak

	bsr		ld_uncmp

	move.l	#msk_ttl,a0			;address of table of mask info
	move.w	#4,d0				;number of masks
	bsr		do_mask
	rts

;table for loading title screen graphics
;address of compressed data, destination address, width/8, width for blitter
titlebkg:
	dc.l		titlebk,	titlescr,		56,	WID448		;title screen background
titledcm:
	dc.l		titlecg,	cglogo,		24,	WID192		;crescent galaxy logo
	dc.l		titlecr,	crlogo,		12,	WID96		;circle reserves logo
	dc.l		tship0,	tship00,		40,	WID320		;ship
	dc.l		tship1,	tship01,		32,	WID256		;ship
;table for loading title screen masks
;A1_BASE				destination address
;width for blitter
;B_COUNT				height, width
;A1_STEP and A2_STEP	1, negative width
;UNCOMP_START			address of compressed mask
;size of mask / 8
msk_ttl:
	dc.l		cglogo,		WID192,	$007000C0,	$0001FF40,	ttlecgm,	(192*112/8)
	dc.l		crlogo,		WID96,	$00480060,	$0001FFA0,	ttlecrm,	(96*72/8)
	dc.l		tship00,		WID320,	$00B80140,	$0001FEC0,	tship0m,	(320*184/8)
	dc.l		tship01,		WID256,	$00C80100,	$0001FF00,	tship1m,	(256*200/8)

titlinput::
	move.l	joyedge,d0
	and.l	#ANY_FIRE,d0			;check for any fire button
	beq.b	.30

	clr.b	chtflag				;assume cheat mode is off
.if CHEAT_ON
	move.b	#1,chtflag
.endif
	cmp.l	#CHEAT_CODE1,chtcode
	bne.b	.20
	cmp.l	#CHEAT_CODE2,chtcode+4
	bne.b	.20
	move.b	#1,chtflag			;turn cheat mode on
.20:
	lea		palette,a0			;get address of palette
	bsr		set_palette
	jsr		initgame
	bra		goselect

.30:	bsr		titlekey				;check for changes to cheat code
.90:	rts

titlekey::
	move.l	joyedge,d0
	and.l	#ANY_KEY,d0			;clear all bits except keypad bits
	beq		.90					;exit if no key was pressed
	btst.l	#KEY_1,d0
	beq.b	.05
	add.b	#1,chtcode
	bra		.90
.05:
	btst.l	#KEY_2,d0
	beq.b	.10
	add.b	#1,chtcode+1
	bra		.90
.10:
	btst.l	#KEY_3,d0
	beq.b	.15
	add.b	#1,chtcode+2
	bra		.90
.15:
	btst.l	#KEY_4,d0
	beq.b	.20
	add.b	#1,chtcode+3
	bra.b	.90
.20:
	btst.l	#KEY_5,d0
	beq.b	.25
	add.b	#1,chtcode+4
	bra.b	.90
.25:
	btst.l	#KEY_6,d0
	beq.b	.30
	add.b	#1,chtcode+5
	bra.b	.90
.30:
	btst.l	#KEY_7,d0
	beq.b	.35
	add.b	#1,chtcode+6
	bra.b	.90
.35:
	btst.l	#KEY_8,d0
	beq.b	.40
	add.b	#1,chtcode+7
	bra.b	.90
.40:
	btst.l	#KEY_9,d0
	beq.b	.90
	clr.l	chtcode
	clr.l	chtcode+4

.90:	rts



titlolst::
;t_scr::
	dc.b		0			; o_type	Bit Mapped type
	dc.b		4			; o_depth
	dc.w		0			; o_xpos	
	dc.w		SCRN_TOP		; o_ypos
	dc.w		288			; o_height
	dc.w		112			; o_dwidth
	dc.w		112			; o_iwidth
	dc.l		titlescr		; o_data
	dc.b		0			; o_flags
	dc.b		0			; o_firstpix
	dc.b		1			; o_pitch
	dc.b		0			; o_index
	dc.l		0			; o_desc
	dc.l		$00202020		; unused byte, remainder, vscale, hscale
;---------------------------------------------------------------------
;t_cg::
	dc.b		1			; o_type	Bit Mapped type
	dc.b		4			; o_depth
	dc.w		132			; o_xpos	
	dc.w		SCRN_TOP		; o_ypos
	dc.w		112			; o_height
	dc.w		48			; o_dwidth
	dc.w		48			; o_iwidth
	dc.l		cglogo		; o_data
	dc.b		TRANS_ON		; o_flags
	dc.b		0			; o_firstpix
	dc.b		1			; o_pitch
	dc.b		0			; o_index
	dc.l		0			; o_desc
	dc.l		$00000000		; unused byte, remainder, vscale, hscale
;---------------------------------------------------------------------
;t_cr::
	dc.b		0			; o_type	Bit Mapped type
	dc.b		4			; o_depth
	dc.w		322			; o_xpos	
	dc.w		SCRN_TOP+300	; o_ypos
	dc.w		72			; o_height
	dc.w		24			; o_dwidth
	dc.w		24			; o_iwidth
	dc.l		crlogo		; o_data
	dc.b		TRANS_ON		; o_flags
	dc.b		0			; o_firstpix
	dc.b		1			; o_pitch
	dc.b		0			; o_index
	dc.l		0			; o_desc
	dc.l		$00202020		; unused byte, remainder, vscale, hscale
;---------------------------------------------------------------------
;t_ship::
	dc.b		1			; o_type	Bit Mapped type
	dc.b		4			; o_depth
	dc.w		SCRN_RIGHT	; o_xpos	
	dc.w		SCRN_TOP		; o_ypos
	dc.w		184			; o_height
	dc.w		80			; o_dwidth
	dc.w		80			; o_iwidth
	dc.l		tship00		; o_data
	dc.b		TRANS_ON		; o_flags
	dc.b		0			; o_firstpix
	dc.b		1			; o_pitch
	dc.b		0			; o_index
	dc.l		0			; o_desc
	dc.l		$00202020		; unused byte, remainder, vscale, hscale
;---------------------------------------------------------------------

